# modified from https://github.com/Pukkah/HTML5-File-Exchange-for-Godot/blob/master/addons/HTML5FileExchange/HTML5FileExchange.gd

extends Node

signal read_completed;
signal load_completed(filename: String, bytes: PackedByteArray);

var js_callback = JavaScriptBridge.create_callback(read_completed.emit);
var js_interface = null;
var is_available_bool := false;

func _ready():
	if OS.get_name() == "Web":
		is_available_bool = true;
		_define_js()
		js_interface = JavaScriptBridge.get_interface("_HTML5FileExchange");
		read_completed.connect(func(_args: Array):
			load_completed.emit(
				JavaScriptBridge.eval("_HTML5FileExchange.fileName", true),
				JavaScriptBridge.eval("_HTML5FileExchange.result", true),
			);
		);
	elif OS.has_feature("android"):
		is_available_bool = true;

func _define_js()->void:
	#Define JS script
	JavaScriptBridge.eval("""
	if (!window._HTML5FileExchange) {
		window._HTML5FileExchange = {};
		window._HTML5FileExchange.upload = function(gd_callback) {
			canceled = true;
			var input = document.createElement('INPUT'); 
			input.setAttribute("type", "file");
			input.click();
			input.addEventListener('change', event => {
				if (event.target.files.length > 0){
					canceled = false;} else {return;}
				var file = event.target.files[0];
				var reader = new FileReader();
				this.fileType = file.type;
				this.fileName = file.name || "file.txt";
				reader.readAsArrayBuffer(file);
				reader.onloadend = (evt) => { // Since here's it's arrow function, "this" still refers to _HTML5FileExchange
					if (evt.target.readyState == FileReader.DONE) {
						this.result = evt.target.result;
						gd_callback(); // ArrayBuffers don't get converted in callbacks so this is just for notification
					}
				}
			  });
		}
	}
	""", true);

func is_available():
	return is_available_bool;

func load_file():
	if OS.get_name() == "Web":
		js_interface.upload(js_callback);
	elif OS.has_feature("android"):
		if !("android.permission.MANAGE_EXTERNAL_STORAGE" in OS.get_granted_permissions()):
			OS.alert("Due to Android and Godot file sandboxing limitations (and my laziness), the game needs a 'manage every file' permission to have a file dialog for the downloads folder. You can disable this afterwards.");
			OS.request_permissions();
			return;
		var dialog: FileDialog = load("res://mods-unpacked/CST1229-BALauncherModLoader/scenes/filebrowser/FileDialog.tscn").instantiate();
		dialog.current_dir = OS.get_system_dir(OS.SYSTEM_DIR_DOWNLOADS);
		dialog.file_mode = FileDialog.FILE_MODE_OPEN_FILE;
		dialog.file_selected.connect(func(path: String):
			var arr := FileAccess.get_file_as_bytes(path);
			if FileAccess.get_open_error():
				OS.alert(error_string(FileAccess.get_open_error()), "Could not open " + path);
			else:
				load_completed.emit(path.get_file(), arr);
		);
		add_child(dialog);
		dialog.visible = true;
