extends "res://launcher.gd"

var mod_settings_button: TextureButton;
var cover_rect: ColorRect;

var current_window: Window;
var play_window_close_back_sound := true;

@onready var use_file_browser = $"/root/ModLoader/CST1229-BALauncherModLoader".use_file_browser;

func _ready():
	$"/root/ModLoader/CST1229-BALauncherModLoader".reload_game_mods();
	DirAccess.make_dir_recursive_absolute("mods" if !use_file_browser else "user://mods");
	super();
	
	var settings_button: TextureButton = $SettingsPanel/Settings;
	mod_settings_button = load("res://ButtonHoverSilent.gd").new();
	mod_settings_button.originalscale = settings_button.originalscale;
	mod_settings_button.name = "ModSettingsButton";
	mod_settings_button.texture_normal = load("res://launcherassets/ui/pixelicons/tools.png");
	mod_settings_button.position = settings_button.position + Vector2(0, 20 * 1.333);
	mod_settings_button.scale = settings_button.scale;
	mod_settings_button.focus_mode = Control.FOCUS_NONE;
	mod_settings_button.button_down.connect(func():
		if updating || current_window:
			return;
		var window: Window = preload("res://mods-unpacked/CST1229-BALauncherModLoader/scenes/mod_settings_window.tscn").instantiate();
		current_window = window;
		add_child(window);
		$Click.play()
		cover_rect.visible = true;
		cover_rect.mouse_filter = Control.MOUSE_FILTER_STOP;
		
		var tween = cover_rect.create_tween();
		tween.tween_property(cover_rect, "modulate", Color.WHITE, 0.2);
		
		play_window_close_back_sound = true;
		window.restart_imminent.connect(func():
			play_window_close_back_sound = false;
			window.queue_free();
			$Fade2.play("FadeOutLauncher");
		);
		window.tree_exited.connect(func():
			current_window = null;
			if play_window_close_back_sound:
				$Back.play();
			else:
				$PlaySound.play();
			var tween2 = cover_rect.create_tween();
			cover_rect.mouse_filter = Control.MOUSE_FILTER_IGNORE;
			tween2.tween_property(cover_rect, "modulate", Color.TRANSPARENT, 0.2);
			tween.tween_callback(func():
				cover_rect.mouse_filter = Control.MOUSE_FILTER_IGNORE;
			);
		);
	);
	$SettingsPanel.add_child(mod_settings_button);
	
	cover_rect = ColorRect.new();
	cover_rect.color = Color(0, 0, 0, 0.5);
	cover_rect.modulate = Color.TRANSPARENT;
	cover_rect.visible = false;
	cover_rect.size = Vector2(1920, 1080);
	cover_rect.z_index = 1000;
	add_child(cover_rect);
	
	if use_file_browser:
		$SocialMedia / Folder.visible = true

func _physics_process(delta: float) -> void :
	if updating:
		mod_settings_button.modulate = Color(0.25, 0.25, 0.25)
	else:
		mod_settings_button.modulate = Color(1, 1, 1)
	if Input.is_action_just_pressed("click") && $UpdateButtons / UpdateLauncher.button_pressed and updating == false and steam == false:
		if $"/root/ModLoader/CST1229-BALauncherModLoader".no_launcher_updates:
			# i wonder if anyone will catch this pronoun usage
			OS.alert("This port of the launcher can't update itself. Please download the latest version if it exists, or ping @cst1229 on Discord to get her to update it.", "sorry blud no launcher updates for you");
			return;
	if !current_window && (use_file_browser || Input.is_key_pressed(KEY_SHIFT) || Input.is_key_pressed(KEY_CTRL)) && Input.is_action_just_pressed("click"):
		if $SocialMedia / Folder.button_pressed:
			if $SocialMedia / Folder.is_hovered():
				$SocialMedia / Folder.disabled = true
				$SocialMedia / Folder.disabled = false
				
				var window: Window = preload("res://mods-unpacked/CST1229-BALauncherModLoader/scenes/filebrowser/FileBrowserWindow.tscn").instantiate();
				current_window = window;
				add_child(window);
				$Click.play()
				cover_rect.visible = true;
				cover_rect.mouse_filter = Control.MOUSE_FILTER_STOP;
				
				var tween = cover_rect.create_tween();
				tween.tween_property(cover_rect, "modulate", Color.WHITE, 0.2);
				
				play_window_close_back_sound = true;
				window.tree_exited.connect(func():
					current_window = null;
					if play_window_close_back_sound:
						$Back.play();
					else:
						$PlaySound.play();
					var tween2 = cover_rect.create_tween();
					cover_rect.mouse_filter = Control.MOUSE_FILTER_IGNORE;
					tween2.tween_property(cover_rect, "modulate", Color.TRANSPARENT, 0.2);
					tween.tween_callback(func():
						cover_rect.mouse_filter = Control.MOUSE_FILTER_IGNORE;
					);
				);
	super(delta);

func _unhandled_input(_ev: InputEvent) -> void:
	if current_window && _ev is InputEventKey:
		var ev := _ev as InputEventKey;
		if ev.pressed && !ev.is_echo() && ev.keycode == KEY_ESCAPE:
			current_window.queue_free();
			get_viewport().set_input_as_handled();

func _on_fade_2_animation_finished(anim_name: StringName) -> void :
	var load_mods = ModLoaderConfig.get_current_config("CST1229-BALauncherModLoader").data.load_mods;
	if anim_name == "FadeOut":
		if game == 0:
			if load_mods:
				# Load songs.pck ourselves to not break story mode
				var success = ProjectSettings.load_resource_pack("songs.pck")
				if !success:
					success = ProjectSettings.load_resource_pack("user://songs.pck")
				success = ProjectSettings.load_resource_pack("sounds.pck")
				if !success:
					success = ProjectSettings.load_resource_pack("user://sounds.pck")
				
				if !($"/root/ModLoader/CST1229-BALauncherModLoader".lite_mode):
					ModLoaderMod.install_script_extension("res://mods-unpacked/CST1229-BALauncherModLoader/level_verification_patch.gd")
				
				print("Reloading game mods...");
				$"/root/ModLoader/CST1229-BALauncherModLoader".load_mods_late();
				print("Loading game mods...");
				$"/root/ModLoader/CST1229-BALauncherModLoader".start_init_mods.call_deferred()
			else:
				print("Game mods disabled.");
	super(anim_name);
