extends CanvasLayer

const ROOT_PATH = "user://";
var last_path := ROOT_PATH;
var path := ROOT_PATH:
	set(value):
		if value != path:
			last_path = path;
			path = value;

@onready var container: TabContainer = $Container;
var last_editor: Control = null;

var editors := {
	"/": "DirEditor",
	".save": "TextEditor",
	".txt": "TextEditor",
	".md": "TextEditor",
	".json": "TextEditor",
	".strc": "TextEditor",
	".gd": "TextEditor",
	".cfg": "TextEditor",
	".log": "TextEditor",
};
func _ready():
	refresh();

func go_back():
	var back_path = path.path_join("..").simplify_path();
	if !back_path.ends_with("/"):
		back_path += "/";
	path = back_path;
	refresh();

func refresh():
	if DisplayServer.is_touchscreen_available():
		container.theme = load("res://mods-unpacked/CST1229-BALauncherModLoader/assets/big_scrollbar.tres");
	else:
		container.theme = null;
	get_window().title = path;
	var current_editor := get_editor_for(path);
	var editor = container.get_node_or_null(current_editor);
	if !editor:
		editor = container.get_node("UnknownEditor");
	if last_editor:
		if last_editor != editor:
			last_editor.visible = false;
		if last_editor.has_method("cleanup"): last_editor.cleanup();
	if editor.has_method("refresh"): editor.refresh();
	if last_editor != editor:
		if editor.has_method("after_setup"):
			editor.after_setup();
	last_editor = editor;
	editor.visible = true;

func get_editor_for(for_path: String) -> String:
	var current_editor := "";
	for suffix in editors.keys():
		if for_path.ends_with(suffix):
			current_editor = editors[suffix];
			break;
	return current_editor;
