extends Window

func _ready() -> void:
	if DisplayServer.is_touchscreen_available():
		content_scale_factor = 1.25;

func _on_close_requested() -> void:
	queue_free();

func _unhandled_input(_ev: InputEvent) -> void:
	if _ev is InputEventKey:
		var ev := _ev as InputEventKey;
		if ev.pressed && !ev.is_echo() && ev.keycode == KEY_ESCAPE:
			queue_free();
			get_viewport().set_input_as_handled();

signal restart_imminent;

func _on_mods_settings_restart_imminent() -> void:
	restart_imminent.emit();
